/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {
        Portal.ListGenerator.vent = new Backbone.Wreqr.EventAggregator(); // ListGenerator.vent in view.initalize() causes error without starting

        describe("Search Applet: Confirmation", function () {
            var view,
                viewEl,
                model = new Backbone.Model({
                    lastName: "patient01",
                    firstName: "zztest",
                    dateOfBirth: "June 16, 1900",
                    age: "110",
                    gender: "FEMALE",
                    inpatient: true,
                    wardLocation: "West22",
                    roombed: "321A",
                    ssn: "000-00-0000"
                });

            beforeEach(function () {
                view = new Portal.ListGenerator.ConfirmationView({
                    model: model
                });
                viewEl = view.render().$el;
            });
            afterEach(function() {
                view.remove();
            });

            it("shows a confirmation button", function () {
                expect(viewEl.find('button').text()).toEqual("Select Patient");
            });
            it("shows the patient's last name", function () {
                expect(viewEl.text()).toContain("Last patient01");
            });
            it("shows the patient's first name", function () {
                expect(viewEl.text()).toContain("First zztest");
            });
            it("shows the patient's date of birth", function () {
                expect(viewEl.text()).toContain("DOB 06/16/1900");
            });
            it("shows the patient's age", function () {
                expect(viewEl.text()).toContain("Age 110");
            });
            it("shows the patient's gender", function () {
                expect(viewEl.text()).toContain("F");
            });
            it("shows the patient's location", function () {
                expect(viewEl.find('ul').text()).toContain("Location West22, 321A");
            });
            it("shows the patient's location as not found", function () {
                view.model.set('roombed', "");
                viewEl = view.render().$el;
                expect(viewEl.text()).toContain("Location West22, No Data Found");
            });
            it("shows the patient location as not admitted", function () {
                view.model.set({
                    inpatient: false,
                    wardLocation: "",
                    roombed: ""
                });
                viewEl = view.render().$el;
                expect(viewEl.text()).toContain("Location Not Currently Admitted");
            });
            it("shows the patient's ssn", function () {
                expect(viewEl.text()).toContain("SSN 000-00-0000");
            });
        });

    });